/*{
	"GUID":"D3FFB279-0581-4c3c-8CAC-CB2E1D148614"
}*/
#ifdef GL_ES
precision mediump float;
#endif

#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT1(image2d_t src_data,  __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc).zyxw;
}

vec4 INPUT2(image2d_t ovelay1,  __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(ovelay1, sampler, tc).zyxw;
}

float _abs(float a)
{
	return a>0?a:(-a);
}

vec4 screen(vec4 base, vec4 blend)
{
    vec4 white = (vec4)(1.0f);
    vec4 result = white - ((white - blend) * (white - base));
    return result;
}

vec4 DoOverlay(vec4 base, vec4 blend)
{
    vec4 result;
    vec4 lumCoeff = (vec4)(0.0721f, 0.7154f, 0.2125f, 0.0f);
    vec4 white = (vec4)(1.0f, 1.0f, 1.0f, 1.0f);
    
    float luminance = dot(base, lumCoeff);
    if (luminance < 0.45f)
        result = 2.0f * blend * base;
    else if (luminance > 0.55f)
        result = white - 2.0f * (white - blend) * (white - base);
    else
    {
        vec4 result1 = 2.0f * blend * base;
        vec4 result2 = white - 2.0f * (white - blend) * (white - base);
        result = mix(result1, result2, (luminance - 0.45f) * 10.0f);
    }
    return result;
}

vec4 RGBA2GRAY(vec4 inRGBA)
{
    float gray = dot(inRGBA.rgb, (vec3)(0.299f, 0.587f, 0.114f));
    vec4 outGray = (vec4)((vec3)(gray, gray, gray), inRGBA.w);
    return outGray;
}

__kernel void MAIN(
      __read_only image2d_t src_data,
      __write_only image2d_t dest_data,        //Data in global memory
      __global FilterParam* param,
	  int alpha)  		// the gpu items/threads should be newW*newH
{
	
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	int2 coordinate = (int2)(get_global_id(0), get_global_id(1));
	vec2 tc = ((float2)(get_global_id0( param), get_global_id1( param)) + (vec2)(0.5f))/(float2)(W,H);
	
    vec4 inBGRA = INPUT1(src_data, param,  tc);
    vec4 color = inBGRA;
    vec4 gray = RGBA2GRAY(inBGRA);
    color = screen(color, gray);
	
    vec3 white = (vec3)(1.0f, 1.0f, 1.0f);
    float lim = 0.0f;
    vec3 cmy = white - color.xyz;
    vec3 cmy1 = (vec3)(0.0f,0.0f,0.0f);
    vec3 cmy2 = (vec3)(0.0f,0.0f,0.0f);
    vec3 cmy3 = (vec3)(0.0f,0.0f,0.0f);
    float vmax = max(max(color.x, color.y), color.z);
    float vmin = min(min(color.x, color.y), color.z);
    float vmid = max(min(color.x, color.y), min(max(color.x, color.y), color.z));
    
    lim = vmax - vmid;
	
    if(vmax == color.x)
    {
        cmy1.x = -cmy.x * lim;
        cmy1.y = -cmy.y * lim * 0.5f;
        cmy1.z = -cmy.z * lim * 0.25f;
    }
    else if(vmax == color.y)
    {
        cmy1.x = -cmy.x * lim * 0.6f;
        cmy1.y = -cmy.y * lim * 0.25f;
        cmy1.z = cmy.z * lim * 0.25f;
    }
    else if(vmax == color.z)
    {
        cmy1.x = -cmy.x * lim * 0.8f;
        cmy1.y = -cmy.y * lim * 0.1f;
        cmy1.z = cmy.z * lim;
    }

    lim = vmid - vmin;
    if (vmin == color.z)
    {
        cmy2.x = -cmy.x * lim * 0.75f;
        cmy2.y = cmy.y * lim * 0.08f;
        cmy2.z = cmy.z * lim * 0.08f;
    }
    else if(vmin == color.y)
    {
        cmy2.x = -cmy.x * lim;
        cmy2.y = -cmy.y * lim;
        cmy2.z = -cmy.z * lim;
    }
    else
    {
        cmy2.y = -cmy.y * lim;
    }

   
    lim = 1.0f - fabs(vmax - 0.5f) - fabs(vmin - 0.5f); 
    cmy3.x = -cmy.x * lim * 0.25f;
    cmy3.y = -cmy.y * lim * 0.25f;
    cmy3.z = -cmy.z * lim * 0.25f;
    
	
    cmy = clamp(cmy + cmy1 + cmy2 + cmy3, 0.0f, 1.0f);
    color.xyz = white - cmy;
    vec4 temp = screen((vec4)(0.3725f, 0.2392f, 0.2157f, inBGRA.w), gray);
    color = DoOverlay(color, temp);
    color.w = inBGRA.w;
    vec4 mapped = color.zyxw;
	
	write_imagef(dest_data, coordinate, inBGRA.zyxw*(1.0f - (float)alpha/100.0f)+mapped.zyxw*(float)alpha/100.0f);
}


